/*
 * Decompiled with CFR 0.152.
 */
package at.hobex.pos.ecr.testgui;

import at.hobex.helper.I18n;
import at.hobex.pos.ecr.testgui.MainFrame;
import at.hobex.pos.ecr.testgui.SimulatorWorker;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

class TerminalSimulatorDialog
extends JDialog {
    private static Logger log = Logger.getLogger(TerminalSimulatorDialog.class);
    private static SimulatorWorker worker = null;
    private static String protocol = "";
    final JTextField portTextField = new JTextField();
    final JTextField timeoutTextField = new JTextField();
    final JTextField tidTextField = new JTextField();
    final JTextField passwordTextField = new JTextField();
    final JComboBox<String> languageCombo = new JComboBox();
    final JComboBox<String> codePageCombo = new JComboBox();
    final JComboBox<String> traceNumberCombo = new JComboBox();
    final JCheckBox referenceCbx = new JCheckBox("Use Reference");
    final JCheckBox shortReceiptCbx = new JCheckBox("Use short customer receipt");
    final JComboBox<String> seasonsGreetingsCombo = new JComboBox();
    final JCheckBox printByBlockCbx = new JCheckBox("Print by block");
    final JCheckBox unattendedModeCbx = new JCheckBox("Unattended Mode");
    final JCheckBox allowPartialCancelCbx = new JCheckBox("Partial Cancel");
    final JCheckBox terminalComputeNoWaitTimeCbx = new JCheckBox("No wait time");
    private final JComboBox<String> protocolCombo = new JComboBox();
    private MainFrame mainFrame;
    private Properties configFile = new Properties();
    private int port;
    private int timeout;
    private String tid = "";
    private String password = "";
    private boolean codepage437;
    private boolean useReference;
    private boolean useShortCustomerReceipt;
    private String seasonsGreetings = "";
    private int traceNumber;
    private boolean printByBlocks;
    private boolean unattendedMode;
    private boolean allowPartialCancel;
    private boolean terminalComputeNoWaitTime;
    private String terminalLanguage = "DE";

    public TerminalSimulatorDialog(final MainFrame mainFrame) {
        super((Dialog)null);
        InputStreamReader reader;
        URL url = this.getClass().getResource("/icon.png");
        ImageIcon imgicon = new ImageIcon(url);
        super.setIconImage(imgicon.getImage());
        this.setResizable(true);
        this.mainFrame = mainFrame;
        JPanel main = new JPanel();
        main.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(main);
        main.setLayout(new GridBagLayout());
        Path currentRelativePath = Paths.get("", new String[0]);
        String s = currentRelativePath.toAbsolutePath().toString();
        System.out.println("Current relative path is: " + s);
        try {
            reader = new FileReader("hobex.gateway.properties");
        }
        catch (FileNotFoundException ex) {
            InputStream fr = this.getClass().getClassLoader().getResourceAsStream("hobex.gateway.properties");
            reader = new InputStreamReader(fr);
        }
        try {
            this.configFile.load(reader);
            protocol = this.configFile.getProperty("hobex.gateway.protocol", "at.hobex.pos.ecr.zvt.ZVTClientSimulator");
            this.port = Integer.valueOf(this.configFile.getProperty("hobex.gateway.com.port", "20007"));
            this.timeout = Integer.valueOf(this.configFile.getProperty("hobex.gateway.timeout", "180000"));
            this.tid = this.configFile.getProperty("hobex.tid", "000101");
            this.password = this.configFile.getProperty("hobex.tecs.password", "");
            this.codepage437 = Boolean.valueOf(this.configFile.getProperty("hobex.zvt.codepage437", "true"));
            this.useReference = Boolean.valueOf(this.configFile.getProperty("hobex.zvt.reference", "false"));
            this.useShortCustomerReceipt = Boolean.valueOf(this.configFile.getProperty("hobex.zvt.shortCustomerReceipt", "false"));
            this.seasonsGreetings = this.configFile.getProperty("hobex.zvt.seasonsGreetings", "");
            this.traceNumber = Integer.valueOf(this.configFile.getProperty("hobex.zvt.traceNumber", "0"));
            this.printByBlocks = Boolean.valueOf(this.configFile.getProperty("hobex.zvt.printByBlocks", "true"));
            if (!this.printByBlocks) {
                log.warn((Object)"Terminal simulator is not supporting 'print by lines' at the moment - set printByBlocks true!");
                this.printByBlocks = true;
            }
            this.terminalLanguage = this.configFile.getProperty("hobex.terminalLanguage", "DE").toUpperCase();
            I18n.setLanguage((String)this.terminalLanguage);
            this.unattendedMode = Boolean.valueOf(this.configFile.getProperty("hobex.tecs.unattendedMode", "false"));
            this.allowPartialCancel = Boolean.valueOf(this.configFile.getProperty("hobex.tecs.partialCancelAllowed", "false"));
            this.terminalComputeNoWaitTime = Boolean.parseBoolean(this.configFile.getProperty("hobex.terminalComputeNoWaitTime"));
        }
        catch (IOException ex) {
            log.warn((Object)"Can't read hobex.gateway.properties!");
            this.dispose();
        }
        int gbcRow = 0;
        final JButton startButton = new JButton("Start");
        final JButton stopButton = new JButton("Stop");
        this.protocolCombo.addItem("TECS-Client Simulator");
        this.protocolCombo.addItem("ZVT-Client Simulator");
        this.protocolCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TerminalSimulatorDialog.this.protocolCombo.getSelectedIndex() == 0) {
                    TerminalSimulatorDialog.this.portTextField.setText("9990");
                    TerminalSimulatorDialog.this.tidTextField.setText("3510001");
                    TerminalSimulatorDialog.this.setSettings(true);
                } else if (TerminalSimulatorDialog.this.protocolCombo.getSelectedIndex() == 1) {
                    TerminalSimulatorDialog.this.portTextField.setText("20007");
                    TerminalSimulatorDialog.this.tidTextField.setText("000101");
                    TerminalSimulatorDialog.this.setSettings(false);
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 4;
        gbc.gridx = 0;
        gbc.gridy = gbcRow++;
        gbc.insets = new Insets(0, 0, 0, 90);
        gbc.weightx = 1.0;
        main.add(this.protocolCombo, gbc);
        this.portTextField.setText("" + this.port);
        this.portTextField.setHorizontalAlignment(4);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 1;
        gbc.gridy = gbcRow;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)this.portTextField, gbc);
        JLabel lbl = new JLabel("Port:");
        lbl.setLabelFor(this.portTextField);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = gbcRow++;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)lbl, gbc);
        this.timeoutTextField.setText("" + this.timeout);
        this.timeoutTextField.setHorizontalAlignment(4);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 1;
        gbc.gridy = gbcRow;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)this.timeoutTextField, gbc);
        lbl = new JLabel("Timeout:");
        lbl.setLabelFor(this.timeoutTextField);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = gbcRow++;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)lbl, gbc);
        this.tidTextField.setText(this.tid);
        this.tidTextField.setHorizontalAlignment(4);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 1;
        gbc.gridy = gbcRow;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)this.tidTextField, gbc);
        lbl = new JLabel("TID (numeric):");
        lbl.setLabelFor(this.tidTextField);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = gbcRow++;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)lbl, gbc);
        this.passwordTextField.setText(this.password);
        this.passwordTextField.setHorizontalAlignment(4);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 1;
        gbc.gridy = gbcRow;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)this.passwordTextField, gbc);
        lbl = new JLabel("Password (8 digit AN):");
        lbl.setLabelFor(this.passwordTextField);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = gbcRow;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)lbl, gbc);
        this.languageCombo.addItem("EN");
        this.languageCombo.addItem("DE");
        switch (this.terminalLanguage.toUpperCase()) {
            case "EN": {
                this.languageCombo.setSelectedIndex(0);
                if (this.protocolCombo.getSelectedIndex() != 1) break;
                this.seasonsGreetingsCombo.setEnabled(false);
                break;
            }
            case "DE": {
                this.languageCombo.setSelectedIndex(1);
                if (this.protocolCombo.getSelectedIndex() != 1) break;
                this.seasonsGreetingsCombo.setEnabled(true);
            }
        }
        this.languageCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TerminalSimulatorDialog.this.languageCombo.getSelectedIndex() == 0 && protocol.equals("at.hobex.pos.ecr.zvt.ZVTClientSimulator")) {
                    TerminalSimulatorDialog.this.seasonsGreetingsCombo.setEnabled(false);
                } else if (TerminalSimulatorDialog.this.languageCombo.getSelectedIndex() == 1 && protocol.equals("at.hobex.pos.ecr.zvt.ZVTClientSimulator")) {
                    TerminalSimulatorDialog.this.seasonsGreetingsCombo.setEnabled(true);
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 4;
        gbc.gridx = 1;
        gbc.gridy = ++gbcRow;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add(this.languageCombo, gbc);
        lbl = new JLabel("Terminal-Language:");
        lbl.setLabelFor(this.languageCombo);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = gbcRow;
        gbc.insets = new Insets(10, 0, 0, 10);
        gbc.weightx = 1.0;
        main.add((Component)lbl, gbc);
        this.codePageCombo.addItem("CP437");
        this.codePageCombo.addItem("ISO8859");
        if (this.codepage437) {
            this.codePageCombo.setSelectedIndex(0);
        } else {
            this.codePageCombo.setSelectedIndex(1);
        }
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 4;
        gbc.gridx = 1;
        gbc.gridy = ++gbcRow;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add(this.codePageCombo, gbc);
        lbl = new JLabel("Codepage:");
        lbl.setLabelFor(this.codePageCombo);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = gbcRow;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)lbl, gbc);
        this.traceNumberCombo.addItem("NO");
        this.traceNumberCombo.addItem("LONG");
        this.traceNumberCombo.addItem("SHORT");
        switch (this.traceNumber) {
            case 0: {
                this.traceNumberCombo.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.traceNumberCombo.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.traceNumberCombo.setSelectedIndex(2);
            }
        }
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 4;
        gbc.gridx = 1;
        gbc.gridy = ++gbcRow;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add(this.traceNumberCombo, gbc);
        lbl = new JLabel("Trace-Number:");
        lbl.setLabelFor(this.traceNumberCombo);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = gbcRow;
        gbc.insets = new Insets(10, 0, 0, 10);
        gbc.weightx = 1.0;
        main.add((Component)lbl, gbc);
        this.seasonsGreetingsCombo.addItem("NO");
        this.seasonsGreetingsCombo.addItem("EASTER");
        this.seasonsGreetingsCombo.addItem("CHRISTMAS");
        switch (this.seasonsGreetings.toUpperCase()) {
            case "EASTER": {
                this.seasonsGreetingsCombo.setSelectedIndex(1);
                break;
            }
            case "CHRISTMAS": {
                this.seasonsGreetingsCombo.setSelectedIndex(2);
                break;
            }
            default: {
                this.seasonsGreetingsCombo.setSelectedIndex(0);
            }
        }
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 4;
        gbc.gridx = 1;
        gbc.gridy = ++gbcRow;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add(this.seasonsGreetingsCombo, gbc);
        lbl = new JLabel("Seasons Greetings:");
        lbl.setLabelFor(this.seasonsGreetingsCombo);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = gbcRow++;
        gbc.insets = new Insets(10, 0, 0, 10);
        gbc.weightx = 1.0;
        main.add((Component)lbl, gbc);
        this.referenceCbx.setSelected(this.useReference);
        this.referenceCbx.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 0;
        gbc.gridy = gbcRow++;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)this.referenceCbx, gbc);
        this.shortReceiptCbx.setSelected(this.useShortCustomerReceipt);
        this.shortReceiptCbx.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 0;
        gbc.gridy = gbcRow++;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)this.shortReceiptCbx, gbc);
        this.printByBlockCbx.setSelected(this.printByBlocks);
        this.printByBlockCbx.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 0;
        gbc.gridy = gbcRow++;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)this.printByBlockCbx, gbc);
        this.unattendedModeCbx.setSelected(this.unattendedMode);
        this.unattendedModeCbx.setEnabled(false);
        this.unattendedModeCbx.setToolTipText("Simulate an unattended Terminal. It sends intermediate status information (Card inserted, ..)");
        this.unattendedModeCbx.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (TerminalSimulatorDialog.this.unattendedModeCbx.isSelected()) {
                    TerminalSimulatorDialog.this.allowPartialCancelCbx.setEnabled(true);
                } else {
                    TerminalSimulatorDialog.this.allowPartialCancelCbx.setSelected(false);
                    TerminalSimulatorDialog.this.allowPartialCancelCbx.setEnabled(false);
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 0;
        gbc.gridy = gbcRow++;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)this.unattendedModeCbx, gbc);
        this.allowPartialCancelCbx.setSelected(this.allowPartialCancel);
        this.allowPartialCancelCbx.setToolTipText("Allows Partial Cancel (optional Feature, available only for unattended Terminals!");
        this.allowPartialCancelCbx.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 0;
        gbc.gridy = gbcRow++;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)this.allowPartialCancelCbx, gbc);
        this.terminalComputeNoWaitTimeCbx.setSelected(this.terminalComputeNoWaitTime);
        this.terminalComputeNoWaitTimeCbx.setEnabled(true);
        this.terminalComputeNoWaitTimeCbx.setToolTipText("No wait time while terminal compute.");
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 0;
        gbc.gridy = gbcRow++;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.weightx = 1.0;
        main.add((Component)this.terminalComputeNoWaitTimeCbx, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = gbcRow;
        gbc.insets = new Insets(30, 0, 0, 0);
        main.add((Component)startButton, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.gridx = 1;
        gbc.gridy = gbcRow;
        gbc.insets = new Insets(30, 5, 0, 0);
        main.add((Component)stopButton, gbc);
        this.getRootPane().setDefaultButton(startButton);
        if (worker == null) {
            startButton.setEnabled(true);
            stopButton.setEnabled(false);
        } else {
            startButton.setEnabled(false);
            stopButton.setEnabled(true);
        }
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter("hobex.gateway.properties"));
                    String tmp = "";
                    switch (TerminalSimulatorDialog.this.protocolCombo.getSelectedIndex()) {
                        case 0: {
                            protocol = "at.hobex.pos.ecr.tecs.TecsClientSimulator";
                            break;
                        }
                        case 1: {
                            protocol = "at.hobex.pos.ecr.zvt.ZVTClientSimulator";
                        }
                    }
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.gateway.protocol", protocol);
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.gateway.com.port", TerminalSimulatorDialog.this.portTextField.getText());
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.gateway.timeout", TerminalSimulatorDialog.this.timeoutTextField.getText());
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.tid", TerminalSimulatorDialog.this.tidTextField.getText());
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.tecs.password", TerminalSimulatorDialog.this.passwordTextField.getText());
                    switch (TerminalSimulatorDialog.this.codePageCombo.getSelectedIndex()) {
                        case 0: {
                            tmp = "true";
                            break;
                        }
                        case 1: {
                            tmp = "false";
                        }
                    }
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.zvt.codepage437", tmp);
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.zvt.reference", TerminalSimulatorDialog.this.referenceCbx.isSelected() ? "true" : "false");
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.zvt.shortCustomerReceipt", TerminalSimulatorDialog.this.shortReceiptCbx.isSelected() ? "true" : "false");
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.zvt.traceNumber", "" + TerminalSimulatorDialog.this.traceNumberCombo.getSelectedIndex());
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.zvt.seasonsGreetings", "" + TerminalSimulatorDialog.this.seasonsGreetingsCombo.getSelectedItem().toString());
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.zvt.printByBlocks", TerminalSimulatorDialog.this.printByBlockCbx.isSelected() ? "true" : "false");
                    switch (TerminalSimulatorDialog.this.languageCombo.getSelectedIndex()) {
                        case 0: {
                            tmp = "EN";
                            break;
                        }
                        case 1: {
                            tmp = "DE";
                        }
                    }
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.terminalLanguage", tmp);
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.tecs.unattendedMode", TerminalSimulatorDialog.this.unattendedModeCbx.isSelected() ? "true" : "false");
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.tecs.partialCancelAllowed", TerminalSimulatorDialog.this.allowPartialCancelCbx.isSelected() ? "true" : "false");
                    TerminalSimulatorDialog.this.configFile.setProperty("hobex.terminalComputeNoWaitTime", TerminalSimulatorDialog.this.terminalComputeNoWaitTimeCbx.isSelected() ? "true" : "false");
                    TerminalSimulatorDialog.this.configFile.store(bw, "Generated by java-api TestGUI Terminalsimulator");
                    bw.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (worker == null) {
                    worker = new SimulatorWorker();
                }
                worker.execute();
                mainFrame.terminalSimulatorWorkStarts();
                TerminalSimulatorDialog.this.dispose();
            }
        });
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (worker != null) {
                    worker.stop();
                    worker = null;
                    mainFrame.workDone();
                    mainFrame.setIntermediateStatusInfoTextAreaTest("");
                    mainFrame.setReceiptTextAreaText("");
                    startButton.setEnabled(true);
                    stopButton.setEnabled(false);
                }
            }
        });
        switch (protocol.toLowerCase()) {
            case "at.hobex.pos.ecr.tecs.tecsclientsimulator": {
                this.protocolCombo.setSelectedIndex(0);
                this.setSettings(true);
                break;
            }
            case "at.hobex.pos.ecr.zvt.zvtclientsimulator": {
                this.protocolCombo.setSelectedIndex(1);
                this.setSettings(false);
            }
        }
        this.setTitle("Terminal Simulator");
        this.setModal(false);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(mainFrame);
        this.setVisible(true);
    }

    public static String getProtocol() {
        return protocol;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        new TerminalSimulatorDialog(null);
    }

    private void setSettings(boolean isTecsClientSimulator) {
        this.languageCombo.setEnabled(!isTecsClientSimulator);
        this.passwordTextField.setEnabled(isTecsClientSimulator);
        this.codePageCombo.setEnabled(!isTecsClientSimulator);
        this.traceNumberCombo.setEnabled(!isTecsClientSimulator);
        if (this.languageCombo.getSelectedIndex() == 0 || isTecsClientSimulator) {
            this.seasonsGreetingsCombo.setEnabled(false);
        } else if (this.languageCombo.getSelectedIndex() == 1 && !isTecsClientSimulator) {
            this.seasonsGreetingsCombo.setEnabled(true);
        }
        this.referenceCbx.setEnabled(!isTecsClientSimulator);
        this.shortReceiptCbx.setEnabled(!isTecsClientSimulator);
        this.printByBlockCbx.setEnabled(!isTecsClientSimulator);
        this.unattendedModeCbx.setEnabled(isTecsClientSimulator);
        this.allowPartialCancelCbx.setEnabled(this.unattendedModeCbx.isSelected());
        this.terminalComputeNoWaitTimeCbx.setEnabled(true);
    }
}

