/*
 * Decompiled with CFR 0.152.
 */
package at.hobex.pos.ecr.testgui;

import at.hobex.pos.ecr.testgui.MainFrame;
import at.hobex.pos.ecr.testgui.SettingFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ReceiptDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JComboBox<String> combo = new JComboBox();
    private JTextArea header = new JTextArea();
    private JTextField cols = new JTextField();

    public ReceiptDialog(final MainFrame mainFrame, SettingFrame settingFrame) {
        this.setTitle("Receipt settings");
        this.setModal(true);
        this.setResizable(false);
        JPanel north = new JPanel();
        JLabel text = new JLabel("In ZVTClient these settings takes no effect!");
        Font newLabelFont = new Font(text.getFont().getName(), 1, text.getFont().getSize());
        text.setFont(newLabelFont);
        north.add(text);
        this.combo.addItem("GenerateReceipt");
        this.combo.addItem("GenerateUnattendedReceipt");
        this.combo.setSelectedIndex(mainFrame.getReceiptType());
        JLabel typeLbl = new JLabel("Receipt type:");
        typeLbl.setLabelFor(this.combo);
        this.cols.setText("" + mainFrame.getReceiptColumns());
        JLabel colsLbl = new JLabel("Columns:");
        colsLbl.setLabelFor(colsLbl);
        String tmp = "";
        if (mainFrame.getReceiptHeader().length > 0) {
            for (int i = 0; i < mainFrame.getReceiptHeader().length; ++i) {
                tmp = tmp + mainFrame.getReceiptHeader()[i];
                if (i >= mainFrame.getReceiptHeader().length - 1) continue;
                tmp = tmp + System.lineSeparator();
            }
        }
        this.header.setText(tmp);
        JScrollPane headerScroller = new JScrollPane(this.header);
        headerScroller.setVerticalScrollBarPolicy(20);
        headerScroller.setHorizontalScrollBarPolicy(30);
        headerScroller.setPreferredSize(new Dimension(50, 90));
        JLabel headerLbl = new JLabel("Header:");
        headerLbl.setLabelFor(this.header);
        URL url = this.getClass().getResource("/icon.png");
        ImageIcon imgicon = new ImageIcon(url);
        super.setIconImage(imgicon.getImage());
        JPanel main = new JPanel();
        JButton okBtn = new JButton("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isOk = true;
                mainFrame.setReceiptType(ReceiptDialog.this.combo.getSelectedIndex());
                int tmp = 0;
                try {
                    tmp = Integer.parseInt(ReceiptDialog.this.cols.getText());
                }
                catch (Exception ex) {
                    isOk = false;
                }
                mainFrame.setReceiptColumns(tmp);
                mainFrame.setReceiptHeader(ReceiptDialog.this.header.getText().split("\n"));
                if (isOk) {
                    ReceiptDialog.this.dispose();
                }
            }
        });
        main.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(10, 10, 5, 10);
        main.add((Component)typeLbl, c);
        c.fill = 2;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(10, 10, 5, 10);
        main.add(this.combo, c);
        c.fill = 2;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(10, 10, 5, 10);
        main.add((Component)headerLbl, c);
        c.fill = 2;
        c.ipady = 40;
        c.weightx = 0.0;
        c.gridheight = 3;
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(10, 10, 5, 10);
        main.add((Component)headerScroller, c);
        c.fill = 2;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.ipady = 0;
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(10, 10, 5, 10);
        main.add((Component)colsLbl, c);
        c.fill = 2;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.ipady = 0;
        c.gridx = 1;
        c.gridy = 2;
        c.insets = new Insets(10, 10, 5, 10);
        main.add((Component)this.cols, c);
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipady = 0;
        c.gridx = 1;
        c.gridy = 5;
        c.insets = new Insets(10, 100, 10, 10);
        main.add((Component)okBtn, c);
        this.getRootPane().setDefaultButton(okBtn);
        this.add((Component)north, "North");
        this.add((Component)main, "Center");
        this.pack();
        this.setLocationRelativeTo(settingFrame);
        this.setVisible(true);
    }
}

