/*
 * Decompiled with CFR 0.152.
 */
package at.hobex.pos.ecr.testgui;

import at.hobex.apitester.helper.Helper;
import at.hobex.pos.ecr.ECRBase;
import at.hobex.pos.ecr.ReceiptHeader;
import at.hobex.pos.ecr.Response;
import at.hobex.pos.ecr.tecs.TecsClient;
import at.hobex.pos.ecr.tecs.TecsResponse;
import at.hobex.pos.ecr.testgui.AgeCheckDropDown;
import at.hobex.pos.ecr.testgui.SettingFrame;
import at.hobex.pos.ecr.testgui.TerminalSimulatorDialog;
import at.hobex.pos.ecr.zvt.ConfigByte;
import at.hobex.pos.ecr.zvt.IntermediateStatusInformation;
import at.hobex.pos.ecr.zvt.IntermediateStatusInformationListener;
import at.hobex.pos.ecr.zvt.ZVTClient;
import at.hobex.pos.ecr.zvt.ZVTResponse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.security.KeyStore;
import java.util.IllegalFormatConversionException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class MainFrame
extends JFrame
implements IntermediateStatusInformationListener {
    private static final long serialVersionUID = 3992891571806478060L;
    private static SettingFrame settingFrame;
    private static Logger log;
    private static JTextPane logTxtArea;
    protected ECRBase terminal;
    private JProgressBar progressBar;
    private JTextArea intermediateStatusInfo;
    private JTextArea receiptTextArea;
    private JMenu extra;
    private JMenu terminalFunctions;
    private JMenu settings;
    private Response lastTx = new Response();
    private String[] receiptHeader = new String[]{"hobex AG", "JAVA API Test GUI", "ecr@hobex.at"};
    private int receiptColumns = 27;
    private int receiptType = 0;
    private int clientId;
    private boolean settingButtonListenerActive = true;

    public MainFrame() {
        logTxtArea = new JTextPane();
        this.setTitle("Hobex.at java-api TestGUI V" + MainFrame.getImplementationVersion());
        URL url = this.getClass().getResource("/icon.png");
        ImageIcon imgicon = new ImageIcon(url);
        super.setIconImage(imgicon.getImage());
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.setMinimumSize(new Dimension(600, 400));
        this.setPreferredSize(new Dimension(1100, 600));
        JPanel main = new JPanel();
        main.setLayout(new GridBagLayout());
        main.setBackground(Color.white);
        this.setContentPane(main);
        logTxtArea.setEditable(false);
        logTxtArea.setFont(new Font("Dialog", 0, 13));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(logTxtArea);
        JScrollPane logScroller = new JScrollPane(panel);
        logScroller.getVerticalScrollBar().setUnitIncrement(16);
        logScroller.setVerticalScrollBarPolicy(22);
        logScroller.setHorizontalScrollBarPolicy(32);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 16;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 8;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(10, 15, 10, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        main.add((Component)logScroller, gbc);
        this.progressBar = new JProgressBar();
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(10, 5, 5, 15);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        main.add((Component)this.progressBar, gbc);
        this.intermediateStatusInfo = new JTextArea(8, 22);
        this.intermediateStatusInfo.setFont(new Font("Segoe UI", 0, 12));
        this.intermediateStatusInfo.setEditable(false);
        JScrollPane intermediateScroller = new JScrollPane(this.intermediateStatusInfo);
        intermediateScroller.setVerticalScrollBarPolicy(21);
        intermediateScroller.setHorizontalScrollBarPolicy(30);
        intermediateScroller.setMinimumSize(new Dimension(intermediateScroller.getPreferredSize().width, intermediateScroller.getPreferredSize().height));
        gbc = new GridBagConstraints();
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 15);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        main.add((Component)intermediateScroller, gbc);
        this.receiptTextArea = new JTextArea();
        this.receiptTextArea.setFont(new Font("Monospaced", 0, 12));
        this.receiptTextArea.setEditable(false);
        JScrollPane receiptScroller = new JScrollPane(this.receiptTextArea);
        receiptScroller.setVerticalScrollBarPolicy(22);
        receiptScroller.setHorizontalScrollBarPolicy(30);
        gbc = new GridBagConstraints();
        gbc.anchor = 12;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 4;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 10, 15);
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        main.add((Component)receiptScroller, gbc);
        JMenuBar menuBar = new JMenuBar();
        this.terminalFunctions = new JMenu("Terminal");
        JMenuItem diagnosisItem = new JMenuItem("Diagnosis");
        diagnosisItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        try {
                            MainFrame.this.workStarts();
                            MainFrame.this.lastTx = MainFrame.this.terminal.diagnosis();
                            MainFrame.this.printReceipt();
                        }
                        catch (Exception e1) {
                            log.error((Object)e1.getMessage());
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        MainFrame.this.workDone();
                    }
                };
                worker.execute();
            }
        });
        JMenuItem eodItem = new JMenuItem("Close Batch");
        eodItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        try {
                            MainFrame.this.workStarts();
                            MainFrame.this.lastTx = MainFrame.this.terminal.closeBatch();
                            MainFrame.this.printReceipt();
                        }
                        catch (Exception e1) {
                            log.error((Object)e1.getMessage());
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        MainFrame.this.workDone();
                    }
                };
                worker.execute();
            }
        });
        JMenuItem turnoverItem = new JMenuItem("Batch Totals");
        turnoverItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        try {
                            MainFrame.this.workStarts();
                            MainFrame.this.lastTx = MainFrame.this.terminal.batchTotals();
                            MainFrame.this.printReceipt();
                        }
                        catch (Exception e1) {
                            log.error((Object)e1.getMessage());
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        MainFrame.this.workDone();
                    }
                };
                worker.execute();
            }
        });
        JMenuItem openCommunicationItem = new JMenuItem("Logon");
        openCommunicationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.terminal instanceof ZVTClient) {
                    final JDialog dialog = new JDialog(MainFrame.this, "Logon", true);
                    dialog.setDefaultCloseOperation(2);
                    dialog.setResizable(false);
                    JPanel main = new JPanel();
                    dialog.add(main);
                    main.setLayout(new GridBagLayout());
                    GridBagConstraints c = new GridBagConstraints();
                    JLabel configByteLbl = new JLabel("Config-Byte:");
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 0;
                    c.gridy = 0;
                    c.insets = new Insets(10, 10, 15, 10);
                    main.add((Component)configByteLbl, c);
                    final JTextField configByte = new JTextField(ConfigByte.getConfigByte());
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 1;
                    c.gridy = 0;
                    c.insets = new Insets(10, 10, 15, 10);
                    main.add((Component)configByte, c);
                    final JCheckBox ecrPrintsPaymentReceipt = new JCheckBox("ecrPrintsPaymentReceipt", ConfigByte.isEcrPrintsPaymentReceipt());
                    ecrPrintsPaymentReceipt.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            ConfigByte.setEcrPrintsPaymentReceipt((boolean)ecrPrintsPaymentReceipt.isSelected());
                            configByte.setText(ConfigByte.getConfigByte());
                        }
                    });
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.gridwidth = 2;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 0;
                    c.gridy = 1;
                    c.insets = new Insets(0, 10, 0, 10);
                    main.add((Component)ecrPrintsPaymentReceipt, c);
                    final JCheckBox ecrPrintsAdministrativeReceipt = new JCheckBox("ecrPrintsAdministrativeReceipt", ConfigByte.isEcrPrintsAdministrativeReceipt());
                    ecrPrintsAdministrativeReceipt.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            ConfigByte.setEcrPrintsAdministrativeReceipt((boolean)ecrPrintsAdministrativeReceipt.isSelected());
                            configByte.setText(ConfigByte.getConfigByte());
                        }
                    });
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.gridwidth = 2;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 0;
                    c.gridy = 2;
                    c.insets = new Insets(0, 10, 0, 10);
                    main.add((Component)ecrPrintsAdministrativeReceipt, c);
                    final JCheckBox ecrRequiredStatusInformation = new JCheckBox("ecrRequiredStatusInformation", ConfigByte.isEcrRequiredStatusInformation());
                    ecrRequiredStatusInformation.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            ConfigByte.setEcrRequiredStatusInformation((boolean)ecrRequiredStatusInformation.isSelected());
                            configByte.setText(ConfigByte.getConfigByte());
                        }
                    });
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.gridwidth = 2;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 0;
                    c.gridy = 3;
                    c.insets = new Insets(0, 10, 0, 10);
                    main.add((Component)ecrRequiredStatusInformation, c);
                    final JCheckBox ecrControlsPaymentFunctions = new JCheckBox("ecrControlsPaymentFunctions", ConfigByte.isEcrControlsPaymentFunctions());
                    ecrControlsPaymentFunctions.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            ConfigByte.setEcrControlsPaymentFunctions((boolean)ecrControlsPaymentFunctions.isSelected());
                            configByte.setText(ConfigByte.getConfigByte());
                        }
                    });
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.gridwidth = 2;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 0;
                    c.gridy = 4;
                    c.insets = new Insets(0, 10, 0, 10);
                    main.add((Component)ecrControlsPaymentFunctions, c);
                    final JCheckBox ecrControlsAdministrativeFunctions = new JCheckBox("ecrControlsAdministrativeFunctions", ConfigByte.isEcrControlsAdministrativeFunctions());
                    ecrControlsAdministrativeFunctions.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            ConfigByte.setEcrControlsAdministrativeFunctions((boolean)ecrControlsAdministrativeFunctions.isSelected());
                            configByte.setText(ConfigByte.getConfigByte());
                        }
                    });
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.gridwidth = 2;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 0;
                    c.gridy = 5;
                    c.insets = new Insets(0, 10, 0, 10);
                    main.add((Component)ecrControlsAdministrativeFunctions, c);
                    final JCheckBox ecrRequestsReceipt = new JCheckBox("ecrRequestsReceipt", ConfigByte.isEcrRequestsReceipt());
                    ecrRequestsReceipt.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            ConfigByte.setEcrRequestsReceipt((boolean)ecrRequestsReceipt.isSelected());
                            configByte.setText(ConfigByte.getConfigByte());
                        }
                    });
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.gridwidth = 2;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 0;
                    c.gridy = 6;
                    c.insets = new Insets(0, 10, 0, 10);
                    main.add((Component)ecrRequestsReceipt, c);
                    configByte.addFocusListener(new FocusListener(){

                        @Override
                        public void focusLost(FocusEvent e) {
                            ConfigByte.setConfigByte((String)configByte.getText());
                            ecrPrintsPaymentReceipt.setSelected(ConfigByte.isEcrPrintsPaymentReceipt());
                            ecrPrintsAdministrativeReceipt.setSelected(ConfigByte.isEcrPrintsAdministrativeReceipt());
                            ecrRequiredStatusInformation.setSelected(ConfigByte.isEcrRequiredStatusInformation());
                            ecrControlsPaymentFunctions.setSelected(ConfigByte.isEcrControlsPaymentFunctions());
                            ecrControlsAdministrativeFunctions.setSelected(ConfigByte.isEcrControlsAdministrativeFunctions());
                            ecrRequestsReceipt.setSelected(ConfigByte.isEcrRequestsReceipt());
                        }

                        @Override
                        public void focusGained(FocusEvent e) {
                        }
                    });
                    JButton okButton = new JButton("OK");
                    okButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                                @Override
                                protected Object doInBackground() throws Exception {
                                    dialog.dispose();
                                    MainFrame.this.workStarts();
                                    ConfigByte.setConfigByte((String)configByte.getText());
                                    try {
                                        MainFrame.this.terminal.logon();
                                    }
                                    catch (Exception e) {
                                        log.warn((Object)e.getMessage());
                                    }
                                    return null;
                                }

                                @Override
                                protected void done() {
                                    MainFrame.this.workDone();
                                }
                            };
                            worker.execute();
                        }
                    });
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 1;
                    c.gridy = 7;
                    c.insets = new Insets(30, 10, 5, 10);
                    main.add((Component)okButton, c);
                    dialog.getRootPane().setDefaultButton(okButton);
                    dialog.pack();
                    dialog.setLocationRelativeTo(MainFrame.this);
                    dialog.setVisible(true);
                } else {
                    SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            MainFrame.this.workStarts();
                            try {
                                MainFrame.this.terminal.openCommunication();
                            }
                            catch (Exception e) {
                                log.warn((Object)e.getMessage());
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            MainFrame.this.workDone();
                        }
                    };
                    worker.execute();
                }
            }
        });
        JMenuItem closeCommunicationItem = new JMenuItem("Logoff");
        closeCommunicationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        MainFrame.this.workStarts();
                        MainFrame.this.terminal.logoff();
                        return null;
                    }

                    @Override
                    protected void done() {
                        MainFrame.this.workDone();
                    }
                };
                worker.execute();
            }
        });
        JMenuItem statusItem = new JMenuItem("Status");
        statusItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() {
                        try {
                            MainFrame.this.workStarts();
                            MainFrame.this.lastTx = MainFrame.this.terminal.status();
                            MainFrame.this.printReceipt();
                        }
                        catch (Exception e1) {
                            log.error((Object)e1.getMessage());
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        MainFrame.this.workDone();
                    }
                };
                worker.execute();
            }
        });
        JMenuItem getTransactionStatusItem = new JMenuItem("Get Transaction Status");
        getTransactionStatusItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "Get Transaction Status", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                dialog.setContentPane(main);
                main.setLayout(new GridBagLayout());
                JLabel refLbl = new JLabel("Reference:");
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 3;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)refLbl, c);
                final JTextField transactionId = new JTextField("" + MainFrame.this.lastTx.getTransactionId());
                transactionId.setColumns(15);
                transactionId.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 3;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)transactionId, c);
                JButton okButton = new JButton("OK");
                c = new GridBagConstraints();
                c.anchor = 14;
                c.gridx = 1;
                c.gridy = 4;
                c.insets = new Insets(15, 10, 15, 10);
                main.add((Component)okButton, c);
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                boolean inputOk = true;
                                boolean c = true;
                                double a = 0.0;
                                double t = 0.0;
                                String r = "";
                                try {
                                    dialog.dispose();
                                    MainFrame.this.workStarts();
                                    if (transactionId.getText() == null || transactionId.getText().length() <= 0) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Transaction ID " + transactionId.getText() + " must not null or empty!");
                                    }
                                    if (inputOk) {
                                        MainFrame.this.lastTx = MainFrame.this.terminal.getTransactionDetails(transactionId.getText());
                                        MainFrame.this.printReceipt();
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem repeatReceiptItem = new JMenuItem("Repeat receipt");
        repeatReceiptItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() {
                        try {
                            MainFrame.this.workStarts();
                            MainFrame.this.lastTx = MainFrame.this.terminal.repeatReceipt();
                            MainFrame.this.printReceipt();
                        }
                        catch (Exception e1) {
                            log.error((Object)e1.getMessage());
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        MainFrame.this.workDone();
                    }
                };
                worker.execute();
            }
        });
        JMenuItem abortItem = new JMenuItem("Abort");
        abortItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        MainFrame.this.progressBar.setIndeterminate(true);
                        return null;
                    }

                    @Override
                    protected void done() {
                        MainFrame.this.workDone();
                    }
                };
                worker.execute();
            }
        });
        abortItem.setEnabled(false);
        JMenuItem openSystenMenuItem = new JMenuItem("Open System Menu");
        openSystenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        try {
                            MainFrame.this.workStarts();
                            MainFrame.this.lastTx = MainFrame.this.terminal.openSystemMenu();
                            MainFrame.this.printReceipt();
                        }
                        catch (Exception e1) {
                            log.error((Object)e1.getMessage());
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        MainFrame.this.workDone();
                    }
                };
                worker.execute();
            }
        });
        openSystenMenuItem.setEnabled(true);
        JMenuItem restartPaymentAppItem = new JMenuItem("Restart Payment App");
        restartPaymentAppItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        try {
                            MainFrame.this.workStarts();
                            MainFrame.this.lastTx = MainFrame.this.terminal.restartPaymentApplication();
                            MainFrame.this.printReceipt();
                        }
                        catch (Exception e1) {
                            log.error((Object)e1.getMessage());
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        MainFrame.this.workDone();
                    }
                };
                worker.execute();
            }
        });
        restartPaymentAppItem.setEnabled(true);
        JMenuItem purchaseItem = new JMenuItem("Purchase");
        purchaseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "Purchase", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                dialog.setContentPane(main);
                main.setLayout(new GridBagLayout());
                JLabel clientLbl = new JLabel("Client-ID:");
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)clientLbl, c);
                final JTextField client = new JTextField("1");
                client.setHorizontalAlignment(4);
                client.setColumns(15);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)client, c);
                JLabel amountLbl = new JLabel("Amount:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amountLbl, c);
                final JTextField amount = new JTextField("1.0");
                amount.setColumns(15);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        amount.selectAll();
                    }
                });
                amount.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amount, c);
                JLabel tipLbl = new JLabel("TIP:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)tipLbl, c);
                final JTextField tip = new JTextField("0.0");
                tip.setColumns(15);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        tip.selectAll();
                    }
                });
                tip.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)tip, c);
                JLabel refLbl = new JLabel("Reference:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 3;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)refLbl, c);
                final JTextField ref = new JTextField("");
                client.setColumns(15);
                ref.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 3;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)ref, c);
                final JTextField cashback = new JTextField("0.0");
                if (MainFrame.this.terminal instanceof ZVTClient) {
                    JLabel CashbackLbl = new JLabel("Cashback:");
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.gridwidth = 1;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 0;
                    c.gridy = 5;
                    c.insets = new Insets(5, 10, 0, 10);
                    main.add((Component)CashbackLbl, c);
                    cashback.setColumns(15);
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowOpened(WindowEvent e) {
                            cashback.selectAll();
                        }
                    });
                    cashback.setHorizontalAlignment(4);
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.gridwidth = 1;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 1;
                    c.gridy = 5;
                    c.insets = new Insets(5, 10, 0, 10);
                    main.add((Component)cashback, c);
                }
                JTextField hexField = new JTextField(10);
                hexField.setEditable(false);
                final JComboBox<AgeCheckDropDown.AgeCheckEnumOptions> ageCheckEnumOptions = new JComboBox<AgeCheckDropDown.AgeCheckEnumOptions>(AgeCheckDropDown.AgeCheckEnumOptions.values());
                if (MainFrame.this.terminal instanceof ZVTClient) {
                    JLabel AgeCheckLabel = new JLabel("Alters\u00c3\u00bcberpr\u00c3\u00bcfung f\u00c3\u00bcr \u00c3\u00bcber: ");
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.gridwidth = 1;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 0;
                    c.gridy = 6;
                    c.insets = new Insets(5, 10, 0, 10);
                    main.add((Component)AgeCheckLabel, c);
                    ageCheckEnumOptions.addActionListener(ef -> {
                        AgeCheckDropDown.AgeCheckEnumOptions selectedOption = (AgeCheckDropDown.AgeCheckEnumOptions)((Object)((Object)ageCheckEnumOptions.getSelectedItem()));
                        if (selectedOption != null) {
                            hexField.setText(selectedOption.getAgeTagValue().toString());
                        }
                    });
                    c = new GridBagConstraints();
                    c.fill = 2;
                    c.gridwidth = 1;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.gridx = 1;
                    c.gridy = 6;
                    c.insets = new Insets(5, 10, 0, 10);
                    main.add(ageCheckEnumOptions, c);
                }
                JButton okButton = new JButton("OK");
                c = new GridBagConstraints();
                c.anchor = 14;
                c.gridx = 1;
                c.gridy = 7;
                c.insets = new Insets(15, 10, 15, 10);
                okButton.requestFocus();
                main.add((Component)okButton, c);
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                boolean inputOk = true;
                                int c = 1;
                                double a = 0.0;
                                double tipValue = 0.0;
                                String r = "";
                                BigDecimal cashbackAmount = new BigDecimal(0.0);
                                try {
                                    block18: {
                                        dialog.dispose();
                                        MainFrame.this.workStarts();
                                        try {
                                            c = Integer.parseInt(client.getText());
                                        }
                                        catch (NumberFormatException e) {
                                            inputOk = false;
                                            JOptionPane.showMessageDialog(MainFrame.this, "Client " + client.getText() + " is not allowed!");
                                        }
                                        try {
                                            a = Double.parseDouble(amount.getText().replace(',', '.'));
                                        }
                                        catch (NumberFormatException e) {
                                            inputOk = false;
                                            JOptionPane.showMessageDialog(MainFrame.this, "Amount " + amount.getText() + " is not allowed!");
                                        }
                                        try {
                                            tipValue = Double.parseDouble(tip.getText().replace(',', '.'));
                                        }
                                        catch (NumberFormatException e) {
                                            inputOk = false;
                                            JOptionPane.showMessageDialog(MainFrame.this, "TIP " + tip.getText() + " is not allowed!");
                                        }
                                        try {
                                            if (cashback != null) {
                                                cashbackAmount = new BigDecimal(Double.parseDouble(cashback.getText().replace(',', '.')));
                                            }
                                        }
                                        catch (NumberFormatException e) {
                                            if (cashbackAmount.toString() == "0.0") break block18;
                                            inputOk = false;
                                            JOptionPane.showMessageDialog(MainFrame.this, "Client " + cashback.getText() + " is not allowed!");
                                        }
                                    }
                                    AgeCheckDropDown.AgeCheckEnumOptions selectedOption = (AgeCheckDropDown.AgeCheckEnumOptions)((Object)ageCheckEnumOptions.getSelectedItem());
                                    if (tipValue > 0.0 && cashbackAmount.doubleValue() > 0.0) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Tip and cashback is not allowed simultaneously!");
                                    } else if (!selectedOption.equals((Object)AgeCheckDropDown.AgeCheckEnumOptions.NO_AGE) && (tipValue > 0.0 || cashbackAmount.doubleValue() > 0.0)) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "AGE_CHECK is not allowed with tip nor with cashback");
                                    }
                                    String string = r = ref.getText() == null ? "" : ref.getText();
                                    if (inputOk) {
                                        if (selectedOption.equals((Object)AgeCheckDropDown.AgeCheckEnumOptions.NO_AGE)) {
                                            MainFrame.this.lastTx = MainFrame.this.terminal.purchase(a, tipValue, r, c);
                                        } else if (MainFrame.this.terminal instanceof ZVTClient) {
                                            MainFrame.this.lastTx = (Response)((ZVTClient)MainFrame.this.terminal).purchase(a, r, selectedOption.getAgeTagValue());
                                        }
                                        MainFrame.this.printReceipt();
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem cancelItem = new JMenuItem("Cancel");
        cancelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JLabel txIDLbl;
                final JDialog dialog = new JDialog(MainFrame.this, "Cancel", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                dialog.setContentPane(main);
                main.setLayout(new GridBagLayout());
                JLabel clientLbl = new JLabel("Client-ID:");
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)clientLbl, c);
                final JTextField client = new JTextField(MainFrame.this.lastTx.getClientId() != null ? "1" + MainFrame.this.lastTx.getClientId() : "1");
                client.setColumns(15);
                client.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)client, c);
                JLabel amountLbl = new JLabel("Amount:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amountLbl, c);
                final JTextField amount = new JTextField("" + MainFrame.this.lastTx.getAmount());
                amount.setColumns(15);
                amount.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amount, c);
                final JTextField txID = new JTextField();
                txID.setHorizontalAlignment(4);
                txID.setColumns(20);
                if (MainFrame.this.terminal instanceof ZVTClient) {
                    try {
                        txID.setText(String.format("%04d", Integer.parseInt(MainFrame.this.lastTx.getReceiptNo())));
                    }
                    catch (NumberFormatException | IllegalFormatConversionException ex) {
                        txID.setText("0000");
                    }
                    txID.setInputVerifier(new InputVerifier(){

                        @Override
                        public boolean verify(JComponent input) {
                            boolean verified = false;
                            if (input instanceof JTextComponent) {
                                JTextComponent field = (JTextComponent)input;
                                try {
                                    field.setText(String.format("%04d", Integer.parseInt(field.getText())));
                                    verified = true;
                                }
                                catch (NumberFormatException | IllegalFormatConversionException e) {
                                    JOptionPane.showMessageDialog(dialog, "Enter a 4 digit Receipt#", "Bad Receipt number!", 0);
                                    verified = false;
                                }
                            }
                            return verified;
                        }
                    });
                    txIDLbl = new JLabel("Receipt#:");
                } else {
                    txID.setText(MainFrame.this.lastTx.getTransactionId());
                    txIDLbl = new JLabel("Transaction ID:");
                }
                txIDLbl.setLabelFor(txID);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)txIDLbl, c);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)txID, c);
                JButton okButton = new JButton("OK");
                c = new GridBagConstraints();
                c.anchor = 14;
                c.gridx = 1;
                c.gridy = 3;
                c.insets = new Insets(15, 10, 15, 10);
                main.add((Component)okButton, c);
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                MainFrame.this.workStarts();
                                boolean inputOk = true;
                                double a = 0.0;
                                int c = 1;
                                try {
                                    dialog.dispose();
                                    try {
                                        c = Integer.parseInt(client.getText());
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Client " + client.getText() + " is not allowed!");
                                    }
                                    try {
                                        a = Double.parseDouble(amount.getText().replace(',', '.'));
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Amount " + amount.getText() + " is not allowed!");
                                    }
                                    if (inputOk) {
                                        MainFrame.this.lastTx = MainFrame.this.terminal.cancel(a, txID.getText(), c);
                                        MainFrame.this.printReceipt();
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem refundItem = new JMenuItem("Refund");
        refundItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "Refund", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                dialog.setContentPane(main);
                main.setLayout(new GridBagLayout());
                JLabel clientLbl = new JLabel("Client-ID:");
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)clientLbl, c);
                final JTextField client = new JTextField("1");
                client.setColumns(15);
                client.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)client, c);
                JLabel amountLbl = new JLabel("Amount:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amountLbl, c);
                final JTextField amount = new JTextField("1.0");
                amount.setColumns(15);
                amount.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amount, c);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        amount.selectAll();
                    }
                });
                JLabel refLbl = new JLabel("Reference:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)refLbl, c);
                final JTextField ref = new JTextField("0");
                ref.setHorizontalAlignment(4);
                ref.setColumns(20);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)ref, c);
                JButton okButton = new JButton("OK");
                c = new GridBagConstraints();
                c.anchor = 14;
                c.gridx = 1;
                c.gridy = 3;
                c.insets = new Insets(15, 10, 15, 10);
                main.add((Component)okButton, c);
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                boolean inputOk = true;
                                int c = 1;
                                double a = 0.0;
                                String r = "";
                                try {
                                    dialog.dispose();
                                    MainFrame.this.workStarts();
                                    try {
                                        c = Integer.parseInt(client.getText());
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Client " + client.getText() + " is not allowed!");
                                    }
                                    try {
                                        a = Double.parseDouble(amount.getText().replace(',', '.'));
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Amount " + amount.getText() + " is not allowed!");
                                    }
                                    String string = r = ref.getText() == null ? "" : ref.getText();
                                    if (inputOk) {
                                        MainFrame.this.lastTx = MainFrame.this.terminal.refund(a, r, c);
                                        MainFrame.this.printReceipt();
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem preAuthItem = new JMenuItem("Pre-Authorization");
        preAuthItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "Preauth", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                dialog.setContentPane(main);
                main.setLayout(new GridBagLayout());
                JLabel clientLbl = new JLabel("Client-ID:");
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)clientLbl, c);
                final JTextField client = new JTextField("1");
                client.setColumns(15);
                client.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)client, c);
                JLabel amountLbl = new JLabel("Amount:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amountLbl, c);
                final JTextField amount = new JTextField("1.0");
                amount.setColumns(15);
                amount.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amount, c);
                JLabel refLbl = new JLabel("Reference:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)refLbl, c);
                final JTextField ref = new JTextField("0");
                ref.setHorizontalAlignment(4);
                ref.setColumns(20);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)ref, c);
                JButton okButton = new JButton("OK");
                c = new GridBagConstraints();
                c.anchor = 14;
                c.gridx = 1;
                c.gridy = 3;
                c.insets = new Insets(15, 10, 15, 10);
                main.add((Component)okButton, c);
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                boolean inputOk = true;
                                int c = 1;
                                double a = 0.0;
                                String r = "";
                                try {
                                    dialog.dispose();
                                    MainFrame.this.workStarts();
                                    try {
                                        c = Integer.parseInt(client.getText());
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Client " + client.getText() + " is not allowed!");
                                    }
                                    try {
                                        a = Double.parseDouble(amount.getText().replace(',', '.'));
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Amount " + amount.getText() + " is not allowed!");
                                    }
                                    String string = r = ref.getText() == null ? "" : ref.getText();
                                    if (inputOk) {
                                        MainFrame.this.lastTx = MainFrame.this.terminal.preauth(a, r);
                                        MainFrame.this.printReceipt();
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem captureItem = new JMenuItem("Capture");
        captureItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "Capture", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                dialog.setContentPane(main);
                main.setLayout(new GridBagLayout());
                JLabel clientLbl = new JLabel("Client-ID:");
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)clientLbl, c);
                final JTextField client = new JTextField(MainFrame.this.lastTx.getClientId() != null ? "" + MainFrame.this.lastTx.getClientId() : "1");
                client.setColumns(15);
                client.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)client, c);
                JLabel amountLbl = new JLabel("Amount:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amountLbl, c);
                final JTextField amount = new JTextField("" + MainFrame.this.lastTx.getAmount());
                amount.setColumns(15);
                amount.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amount, c);
                JLabel txIDLabel = new JLabel(MainFrame.this.terminal instanceof TecsClient ? "Transaction ID:" : "Trace Number:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)txIDLabel, c);
                final JTextField traceNumber = new JTextField(MainFrame.this.lastTx.getTransactionId());
                traceNumber.setHorizontalAlignment(4);
                traceNumber.setColumns(20);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)traceNumber, c);
                JButton okButton = new JButton("OK");
                c = new GridBagConstraints();
                c.anchor = 14;
                c.gridx = 1;
                c.gridy = 3;
                c.insets = new Insets(15, 10, 15, 10);
                main.add((Component)okButton, c);
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                boolean inputOk = true;
                                int c = 1;
                                double a = 0.0;
                                try {
                                    MainFrame.this.workStarts();
                                    dialog.dispose();
                                    try {
                                        c = Integer.parseInt(client.getText());
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Client " + client.getText() + " is not allowed!");
                                    }
                                    try {
                                        a = Double.parseDouble(amount.getText().replace(',', '.'));
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Amount " + amount.getText() + " is not allowed!");
                                    }
                                    if (inputOk) {
                                        MainFrame.this.lastTx = MainFrame.this.terminal.capture(a, traceNumber.getText());
                                        MainFrame.this.printReceipt();
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem preAuthCancelItem = new JMenuItem("Pre-Authorization Cancel");
        preAuthCancelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "Preauth-Cancel", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                dialog.setContentPane(main);
                main.setLayout(new GridBagLayout());
                JLabel clientLbl = new JLabel("Client-ID:");
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)clientLbl, c);
                final JTextField client = new JTextField(MainFrame.this.lastTx.getClientId() != null ? "" + MainFrame.this.lastTx.getClientId() : "1");
                client.setColumns(15);
                client.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)client, c);
                JLabel amountLbl = new JLabel("Amount:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amountLbl, c);
                final JTextField amount = new JTextField("" + MainFrame.this.lastTx.getAmount());
                amount.setColumns(15);
                amount.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amount, c);
                JLabel txIDLabel = new JLabel(MainFrame.this.terminal instanceof TecsClient ? "Transaction ID:" : "Trace Number:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)txIDLabel, c);
                final JTextField txID = new JTextField(MainFrame.this.lastTx.getTransactionId());
                txID.setHorizontalAlignment(4);
                txID.setColumns(20);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)txID, c);
                JButton okButton = new JButton("OK");
                c = new GridBagConstraints();
                c.anchor = 14;
                c.gridx = 1;
                c.gridy = 3;
                c.insets = new Insets(15, 10, 15, 10);
                main.add((Component)okButton, c);
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                boolean inputOk = true;
                                int c = 1;
                                double a = 0.0;
                                try {
                                    MainFrame.this.workStarts();
                                    dialog.dispose();
                                    try {
                                        c = Integer.parseInt(client.getText());
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Client " + client.getText() + " is not allowed!");
                                    }
                                    try {
                                        a = Double.parseDouble(amount.getText().replace(',', '.'));
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Amount " + amount.getText() + " is not allowed!");
                                    }
                                    if (inputOk) {
                                        MainFrame.this.lastTx = MainFrame.this.terminal.preauthCancel(a, txID.getText());
                                        MainFrame.this.printReceipt();
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem motoItem = new JMenuItem("MO/TO");
        motoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "MO/TO", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                dialog.setContentPane(main);
                main.setLayout(new GridBagLayout());
                JLabel clientLbl = new JLabel("Client-ID:");
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)clientLbl, c);
                final JTextField client = new JTextField("1");
                client.setHorizontalAlignment(4);
                client.setColumns(15);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 0;
                c.insets = new Insets(15, 10, 0, 10);
                main.add((Component)client, c);
                JLabel amountLbl = new JLabel("Amount:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amountLbl, c);
                final JTextField amount = new JTextField("1.0");
                amount.setColumns(15);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        amount.selectAll();
                    }
                });
                amount.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)amount, c);
                JLabel refLbl = new JLabel("Reference:");
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)refLbl, c);
                final JTextField ref = new JTextField("0");
                client.setColumns(15);
                ref.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 2;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)ref, c);
                JButton okButton = new JButton("OK");
                c = new GridBagConstraints();
                c.anchor = 14;
                c.gridx = 1;
                c.gridy = 3;
                c.insets = new Insets(15, 10, 15, 10);
                main.add((Component)okButton, c);
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                boolean inputOk = true;
                                int c = 1;
                                double a = 0.0;
                                String r = "";
                                try {
                                    dialog.dispose();
                                    MainFrame.this.workStarts();
                                    try {
                                        c = Integer.parseInt(client.getText());
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Client " + client.getText() + " is not allowed!");
                                    }
                                    try {
                                        a = Double.parseDouble(amount.getText().replace(',', '.'));
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Amount " + amount.getText() + " is not allowed!");
                                    }
                                    String string = r = ref.getText() == null ? "" : ref.getText();
                                    if (inputOk) {
                                        MainFrame.this.lastTx = MainFrame.this.terminal.moto(a, r, c);
                                        MainFrame.this.printReceipt();
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        motoItem.setEnabled(true);
        JMenuItem loyaltyPointsCollect = new JMenuItem("PointsCollect");
        loyaltyPointsCollect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "PointsCollect", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                dialog.setContentPane(main);
                main.setLayout(new GridBagLayout());
                JLabel pointsLbl = new JLabel("Points:");
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)pointsLbl, c);
                final JTextField pointsTextField = new JTextField("0.0");
                pointsTextField.setColumns(15);
                pointsTextField.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)pointsTextField, c);
                JButton okButton = new JButton("OK");
                c = new GridBagConstraints();
                c.anchor = 14;
                c.gridx = 1;
                c.gridy = 3;
                c.insets = new Insets(15, 10, 15, 10);
                main.add((Component)okButton, c);
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                boolean inputOk = true;
                                double points = 0.0;
                                try {
                                    MainFrame.this.workStarts();
                                    dialog.dispose();
                                    try {
                                        points = Double.parseDouble(pointsTextField.getText().replace(',', '.'));
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Points " + pointsTextField.getText() + " is not allowed!");
                                    }
                                    if (inputOk) {
                                        MainFrame.this.lastTx = MainFrame.this.terminal.pointsCollect(points);
                                        MainFrame.this.printReceipt();
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem loyaltyPointsSpending = new JMenuItem("PointsSpending");
        loyaltyPointsSpending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "PointsSpending", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                dialog.setContentPane(main);
                main.setLayout(new GridBagLayout());
                JLabel pointsLbl = new JLabel("Points:");
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)pointsLbl, c);
                final JTextField pointsTextField = new JTextField("0");
                pointsTextField.setColumns(15);
                pointsTextField.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)pointsTextField, c);
                JButton okButton = new JButton("OK");
                c = new GridBagConstraints();
                c.anchor = 14;
                c.gridx = 1;
                c.gridy = 3;
                c.insets = new Insets(15, 10, 15, 10);
                main.add((Component)okButton, c);
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                boolean inputOk = true;
                                int points = 0;
                                try {
                                    MainFrame.this.workStarts();
                                    dialog.dispose();
                                    try {
                                        points = Integer.parseInt(pointsTextField.getText().replace(',', '.'));
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Points " + pointsTextField.getText() + " is not allowed!");
                                    }
                                    if (inputOk) {
                                        log.error((Object)"PointsSpending not supported!");
                                        MainFrame.this.printReceipt();
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem loyaltyPointsBalance = new JMenuItem("PointsBalance");
        loyaltyPointsBalance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        boolean inputOk = true;
                        double amount = 0.0;
                        try {
                            MainFrame.this.workStarts();
                            log.error((Object)"PointsBalance not supported!");
                            MainFrame.this.printReceipt();
                        }
                        catch (Exception e1) {
                            log.error((Object)e1.getMessage());
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        MainFrame.this.workDone();
                    }
                };
                worker.execute();
            }
        });
        JMenuItem loyaltyVoucherLoad = new JMenuItem("VoucherLoad");
        loyaltyVoucherLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "VoucherLoad", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                dialog.setContentPane(main);
                main.setLayout(new GridBagLayout());
                JLabel pointsLbl = new JLabel("Amount:");
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)pointsLbl, c);
                final JTextField pointsTextField = new JTextField("0.0");
                pointsTextField.setColumns(15);
                pointsTextField.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)pointsTextField, c);
                JButton okButton = new JButton("OK");
                c = new GridBagConstraints();
                c.anchor = 14;
                c.gridx = 1;
                c.gridy = 3;
                c.insets = new Insets(15, 10, 15, 10);
                main.add((Component)okButton, c);
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                boolean inputOk = true;
                                double amount = 0.0;
                                try {
                                    MainFrame.this.workStarts();
                                    dialog.dispose();
                                    try {
                                        amount = Double.parseDouble(pointsTextField.getText().replace(',', '.'));
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Points " + pointsTextField.getText() + " is not allowed!");
                                    }
                                    if (inputOk) {
                                        MainFrame.this.lastTx = MainFrame.this.terminal.voucherLoad(amount);
                                        MainFrame.this.printReceipt();
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem loyaltyVoucherPay = new JMenuItem("VoucherPay");
        loyaltyVoucherPay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "VoucherPay", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                dialog.setContentPane(main);
                main.setLayout(new GridBagLayout());
                JLabel pointsLbl = new JLabel("Amount:");
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)pointsLbl, c);
                final JTextField pointsTextField = new JTextField("0.0");
                pointsTextField.setColumns(15);
                pointsTextField.setHorizontalAlignment(4);
                c = new GridBagConstraints();
                c.fill = 2;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                c.gridy = 1;
                c.insets = new Insets(5, 10, 0, 10);
                main.add((Component)pointsTextField, c);
                JButton okButton = new JButton("OK");
                c = new GridBagConstraints();
                c.anchor = 14;
                c.gridx = 1;
                c.gridy = 3;
                c.insets = new Insets(15, 10, 15, 10);
                main.add((Component)okButton, c);
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                boolean inputOk = true;
                                double amount = 0.0;
                                try {
                                    MainFrame.this.workStarts();
                                    dialog.dispose();
                                    try {
                                        amount = Double.parseDouble(pointsTextField.getText().replace(',', '.'));
                                    }
                                    catch (NumberFormatException e) {
                                        inputOk = false;
                                        JOptionPane.showMessageDialog(MainFrame.this, "Points " + pointsTextField.getText() + " is not allowed!");
                                    }
                                    if (inputOk) {
                                        MainFrame.this.lastTx = MainFrame.this.terminal.voucherPay(amount);
                                        MainFrame.this.printReceipt();
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem loyaltyVoucherBalance = new JMenuItem("VoucherBalance");
        loyaltyVoucherBalance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        boolean inputOk = true;
                        double amount = 0.0;
                        try {
                            MainFrame.this.workStarts();
                            MainFrame.this.lastTx = MainFrame.this.terminal.voucherBalance();
                            MainFrame.this.printReceipt();
                        }
                        catch (Exception e1) {
                            log.error((Object)e1.getMessage());
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        MainFrame.this.workDone();
                    }
                };
                worker.execute();
            }
        });
        JMenu loyaltyMenu = new JMenu("Loyalty");
        loyaltyMenu.add(loyaltyPointsCollect);
        loyaltyMenu.add(loyaltyPointsSpending);
        loyaltyMenu.add(loyaltyPointsBalance);
        loyaltyMenu.add(loyaltyVoucherLoad);
        loyaltyMenu.add(loyaltyVoucherPay);
        loyaltyMenu.add(loyaltyVoucherBalance);
        this.terminalFunctions.add(openCommunicationItem);
        this.terminalFunctions.add(closeCommunicationItem);
        this.terminalFunctions.add(diagnosisItem);
        this.terminalFunctions.add(turnoverItem);
        this.terminalFunctions.add(eodItem);
        this.terminalFunctions.add(statusItem);
        this.terminalFunctions.add(getTransactionStatusItem);
        this.terminalFunctions.add(repeatReceiptItem);
        this.terminalFunctions.add(abortItem);
        this.terminalFunctions.add(openSystenMenuItem);
        this.terminalFunctions.add(restartPaymentAppItem);
        this.terminalFunctions.addSeparator();
        this.terminalFunctions.add(purchaseItem);
        this.terminalFunctions.add(cancelItem);
        this.terminalFunctions.add(refundItem);
        this.terminalFunctions.add(preAuthItem);
        this.terminalFunctions.add(captureItem);
        this.terminalFunctions.add(preAuthCancelItem);
        this.terminalFunctions.add(motoItem);
        this.terminalFunctions.add(loyaltyMenu);
        menuBar.add(this.terminalFunctions);
        this.extra = new JMenu("Extra");
        JMenuItem zvtMessageParser = new JMenuItem("ZVT Message Parser");
        zvtMessageParser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "ZVT Message Parser", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                main.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                dialog.add(main);
                main.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                final JTextArea zvtMessage = new JTextArea(5, 100);
                zvtMessage.setWrapStyleWord(true);
                zvtMessage.setLineWrap(true);
                JScrollPane scroll = new JScrollPane(zvtMessage, 20, 31);
                JButton okButton = new JButton("OK");
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                ZVTResponse response = new ZVTResponse();
                                try {
                                    if (zvtMessage.getText().isEmpty()) {
                                        JOptionPane.showMessageDialog(MainFrame.this, "Check input!");
                                    } else {
                                        MainFrame.this.workStarts();
                                        dialog.dispose();
                                        try {
                                            if (zvtMessage.getText().startsWith("1002")) {
                                                byte[] tmp = Helper.unescapeResponse(Helper.hexStringToByteArray(zvtMessage.getText()));
                                                response.parse(tmp);
                                            } else {
                                                response.parse(Helper.hexStringToByteArray(zvtMessage.getText()));
                                            }
                                            MainFrame.this.receiptTextArea.setText(response.getMerchantReceipt() + response.getCustomerReceipt());
                                        }
                                        catch (Exception ex) {
                                            log.error((Object)"INVALID INPUT!");
                                        }
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                c.weightx = 0.5;
                c.gridx = 0;
                c.gridy = 0;
                main.add((Component)scroll, c);
                c.weightx = 1.0;
                c.anchor = 13;
                c.gridx = 0;
                c.gridy = 2;
                c.insets = new Insets(10, 0, 0, 0);
                main.add((Component)okButton, c);
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        this.extra.add(zvtMessageParser);
        JMenuItem tecsMessageParser = new JMenuItem("TECS Message Parser");
        tecsMessageParser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(MainFrame.this, "TECS Message Parser", true);
                dialog.setDefaultCloseOperation(2);
                dialog.setResizable(false);
                JPanel main = new JPanel();
                main.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                dialog.add(main);
                main.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                final JTextArea tecsMessage = new JTextArea(5, 100);
                tecsMessage.setWrapStyleWord(true);
                tecsMessage.setLineWrap(true);
                JScrollPane scroll = new JScrollPane(tecsMessage, 20, 31);
                JButton okButton = new JButton("OK");
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                try {
                                    if (tecsMessage.getText().isEmpty()) {
                                        JOptionPane.showMessageDialog(MainFrame.this, "Check input!");
                                    } else {
                                        MainFrame.this.workStarts();
                                        dialog.dispose();
                                        try {
                                            TecsResponse response = new TecsResponse(tecsMessage.getText());
                                            MainFrame.this.receiptTextArea.setText(response.getMerchantReceipt() + response.getCustomerReceipt());
                                        }
                                        catch (Exception ex) {
                                            log.error((Object)"INVALID INPUT!");
                                        }
                                    }
                                }
                                catch (Exception e1) {
                                    log.error((Object)e1.getMessage());
                                }
                                return null;
                            }

                            @Override
                            protected void done() {
                                MainFrame.this.workDone();
                            }
                        };
                        worker.execute();
                    }
                });
                c.weightx = 0.5;
                c.gridx = 0;
                c.gridy = 0;
                main.add((Component)scroll, c);
                c.weightx = 1.0;
                c.anchor = 13;
                c.gridx = 0;
                c.gridy = 2;
                c.insets = new Insets(10, 0, 0, 0);
                main.add((Component)okButton, c);
                dialog.getRootPane().setDefaultButton(okButton);
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
            }
        });
        this.extra.add(tecsMessageParser);
        JMenuItem terminalSimulator = new JMenuItem("Terminal Simulator");
        terminalSimulator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new TerminalSimulatorDialog(MainFrame.this);
            }
        });
        this.extra.add(terminalSimulator);
        menuBar.add(this.extra);
        this.settings = new JMenu("Settings");
        this.settings.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MainFrame.this.settingButtonListenerActive) {
                    settingFrame.setLocationRelativeTo(MainFrame.this);
                    settingFrame.setVisible(true);
                }
            }
        });
        menuBar.add(this.settings);
        JMenu help = new JMenu("Help");
        help.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JOptionPane.showMessageDialog(MainFrame.this, "JAVA-API-Testtool V" + MainFrame.getImplementationVersion() + "\nby hobex AG\nwww.hobex.at\n\nTo edit hobex.properties or log4j.properties\nopen the JAR with 7-zip\n\necr@hobex.at", "Info", 1);
            }
        });
        menuBar.add(help);
        this.setJMenuBar(menuBar);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Object[] possibilities = new String[]{"with send logoff command?", "don't send logoff command?"};
                String s = (String)JOptionPane.showInputDialog(MainFrame.this, "Want to exit program\n", "Close Window?", 3, null, possibilities, 0);
                if (s != null && s.contains("with")) {
                    SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            MainFrame.this.terminal.closeCommunication();
                            Thread.sleep(2000L);
                            System.exit(0);
                            return null;
                        }
                    };
                    worker.execute();
                } else {
                    if (s == null) {
                        return;
                    }
                    System.exit(0);
                }
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(false);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedLookAndFeelException e) {
                    e.printStackTrace();
                }
                MainFrame mainFrame = new MainFrame();
                settingFrame = new SettingFrame(mainFrame);
            }
        });
    }

    static void initSSL() {
        try {
            log.debug((Object)"Init SSL Trust Store");
            InputStream truststoreInput = Thread.currentThread().getContextClassLoader().getResourceAsStream("hpg-ecr-2018.ts");
            MainFrame.setSSLFactories(truststoreInput, "hobex2k12");
            truststoreInput.close();
        }
        catch (Exception ex) {
            System.setProperty("javax.net.ssl.trustStore", "hpg-ecr-2018.ts");
            System.setProperty("javax.net.ssl.trustStorePassword", "hobex2k12");
        }
    }

    private static void setSSLFactories(InputStream trustStream, String trustStreamPassword) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] trustPassword = trustStreamPassword.toCharArray();
        trustStore.load(trustStream, trustPassword);
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(trustStore);
        TrustManager[] trustManagers = trustFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustManagers, null);
        SSLContext.setDefault(sslContext);
    }

    public static JTextPane getLogTxtArea() {
        return logTxtArea;
    }

    private static String getImplementationVersion() {
        String manifestPath = "";
        manifestPath = "jar:rsrc:java-api-tester.jar!/META-INF/MANIFEST.MF";
        try {
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String value = attr.getValue("Implementation-Version");
            return value;
        }
        catch (IOException e) {
            log.error((Object)("getVersion: " + e.getMessage()));
            return " DEVELOP";
        }
    }

    private void workStarts() {
        this.receiptTextArea.setText("");
        this.intermediateStatusInfo.setText("");
        this.progressBar.setIndeterminate(true);
        this.terminalFunctions.setEnabled(false);
        this.extra.setEnabled(false);
        this.settingButtonListenerActive = false;
        this.settings.setEnabled(false);
    }

    protected void terminalSimulatorWorkStarts() {
        this.progressBar.setIndeterminate(true);
        this.terminalFunctions.setEnabled(false);
        this.extra.getItem(0).setEnabled(false);
        this.extra.getItem(1).setEnabled(false);
        this.settings.setEnabled(false);
        this.settingButtonListenerActive = false;
        this.intermediateStatusInfo.setText("\n\n\n   TERMINAL SIMULATOR IS RUNNING!");
        this.receiptTextArea.setText("Send Amount:\n 7.0 | 97.00 - Get Debitcard\n 7.1 | 97.10 - Get Maestro\n 7.2 | 97.20 - Get Mastercard Debit\n 7.3 | 97.30 - Get MC D. CTLS NO CVM\n 7.4 | 97.40 - Get MC D. CTLS&PIN\n 7.5 | 97.50 - Get MC D. Chip&PIN\n 8.0 | 98.00 - Get Creditcard\n 8.1 | 98.10 - Get Mastercard\n 8.2 | 98.20 - Get Visa\n 8.3 | 98.30 - Get signature based TX\n 9.9 | 99.00 - simulate abort\n               (ZVT: no Receipt)\n 9.1 | 99.10 - sim System error\n               (error Receipt)\n26,10| ---   - Get AgeResponse N.OK\n26.20| ---   - Get AgeResponse OK\n26.30| ---   - Get AgeResponse Card\n               not supported\n26.40| ---   - Get AgeResponse Verification\n               not supported");
    }

    protected void workDone() {
        this.progressBar.setIndeterminate(false);
        this.terminalFunctions.setEnabled(true);
        this.extra.setEnabled(true);
        this.extra.getItem(0).setEnabled(true);
        this.extra.getItem(1).setEnabled(true);
        this.settings.setEnabled(true);
        this.settingButtonListenerActive = true;
    }

    private void printReceipt() {
        if (!(this.terminal instanceof ZVTClient)) {
            switch (this.receiptType) {
                case 0: {
                    String tmp = this.lastTx.GenerateReceipt(ReceiptHeader.SALES, this.receiptHeader, this.lastTx.getLanguage(), this.receiptColumns);
                    tmp = tmp + this.lastTx.GenerateReceipt(ReceiptHeader.CUSTOMER, this.receiptHeader, this.lastTx.getLanguage(), this.receiptColumns);
                    this.receiptTextArea.setText(tmp);
                    break;
                }
                case 1: {
                    String tmp = this.lastTx.GenerateUnattendedReceipt(ReceiptHeader.SALES, this.lastTx.getLanguage(), this.receiptColumns);
                    tmp = tmp + this.lastTx.GenerateUnattendedReceipt(ReceiptHeader.CUSTOMER, this.lastTx.getLanguage(), this.receiptColumns);
                    this.receiptTextArea.setText(tmp);
                }
            }
        } else {
            this.receiptTextArea.setText(this.lastTx.getMerchantReceipt() + this.lastTx.getCustomerReceipt());
        }
    }

    public JTextArea getReceiptTextArea() {
        return this.receiptTextArea;
    }

    public void setReceiptTextArea(JTextArea receiptTextArea) {
        this.receiptTextArea = receiptTextArea;
    }

    public String[] getReceiptHeader() {
        return this.receiptHeader;
    }

    public void setReceiptHeader(String[] receiptHeader) {
        this.receiptHeader = receiptHeader;
    }

    public int getReceiptColumns() {
        return this.receiptColumns;
    }

    public void setReceiptColumns(int receiptColumns) {
        this.receiptColumns = receiptColumns;
    }

    public int getReceiptType() {
        return this.receiptType;
    }

    public void setReceiptType(int receiptType) {
        this.receiptType = receiptType;
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public void setIntermediateStatusInfoTextAreaTest(String intermediateStatusInfoText) {
        this.intermediateStatusInfo.setText(intermediateStatusInfoText);
    }

    public void setReceiptTextAreaText(String receiptText) {
        this.receiptTextArea.setText(receiptText);
    }

    public void intermediateStatusInformation(IntermediateStatusInformation arg0) {
        log.info((Object)("INTERMEDIATE STATUS INFO: " + arg0.toString()));
        this.intermediateStatusInfo.append(arg0 + System.lineSeparator());
        this.intermediateStatusInfo.setCaretPosition(this.intermediateStatusInfo.getDocument().getLength());
    }

    static {
        log = Logger.getLogger(MainFrame.class);
    }
}

