/*
 * Decompiled with CFR 0.152.
 */
package at.hobex.apitester.helper;

import at.hobex.pos.ecr.testgui.MainFrame;
import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class TextAreaAppender
extends AppenderSkeleton {
    protected void append(LoggingEvent event) {
        this.layout = new PatternLayout("%d - %m%n");
        String msg = this.layout.format(event);
        JTextPane textArea = MainFrame.getLogTxtArea();
        Color color = Color.BLACK;
        if (event.getLevel() == Level.INFO) {
            color = Color.BLUE;
        } else if (event.getLevel() == Level.WARN || event.getLevel() == Level.ERROR || event.getLevel() == Level.FATAL) {
            color = Color.RED;
        }
        if (msg.contains("INTERMEDIATE STATUS INFO:")) {
            color = Color.MAGENTA;
        }
        if (msg.endsWith("\u0000" + System.lineSeparator())) {
            msg = msg.replace("\u0000", "");
        }
        this.appendToPane(textArea, msg, color);
        MainFrame.getLogTxtArea().setCaretPosition(MainFrame.getLogTxtArea().getDocument().getLength());
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    private void appendToPane(JTextPane tp, String msg, Color c) {
        int len = tp.getDocument().getLength();
        Style style = tp.addStyle("", null);
        try {
            StyleConstants.setForeground(style, c);
            tp.getStyledDocument().insertString(len, msg, style);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

