/*
 * Decompiled with CFR 0.152.
 */
package at.hobex.apitester.helper;

import at.hobex.pos.ecr.ECRException;
import java.util.ArrayList;
import java.util.List;

public class Helper {
    private static final byte DLE = 16;

    public static byte[] unescapeResponse(byte[] res) throws ECRException {
        ArrayList<Byte> tmp = new ArrayList<Byte>();
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (byte b : res) {
            tmp.add(b);
        }
        tmp.subList(0, 2).clear();
        tmp.subList(tmp.size() - 4, tmp.size()).clear();
        boolean lastByteWasDLE = false;
        for (byte b : Helper.byteListToByteArray(tmp)) {
            if (lastByteWasDLE && b == 16) {
                result.add(b);
                lastByteWasDLE = false;
                continue;
            }
            if (!lastByteWasDLE && b == 16) {
                lastByteWasDLE = true;
                continue;
            }
            if (lastByteWasDLE) {
                throw new ECRException("Invalid Escaped APDU data, DLE was not escaped");
            }
            result.add(b);
        }
        return Helper.byteListToByteArray(result);
    }

    public static byte[] hexStringToByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)(v & 0xFF);
        }
        return b;
    }

    public static byte[] byteListToByteArray(List<Byte> byteList) {
        byte[] data = new byte[byteList.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = byteList.get(i);
        }
        return data;
    }
}

